<?php

function generate_config()
{
    include_once("../config/node_parameters.php");  /* DO NOT DELETE THIS LINE */ //All link parameters
    
    
return "
	
!!!! Router CISCO -- $IP

interface $INTERFACE_SRC.$SUBINTERFACE_SRC l2transport
    description $MAP_NAME
    encapsulation dot1q $VLAN_SRC
    mtu 9018
    rewrite ingress tag pop 1 symmetric
    service-policy input $MAP_NAME-IN
    service-policy output $MAP_NAME-OUT		    
    !lldp
    !	transmit disable
    !	exit
exit

policy-map $MAP_NAME-IN
    class class-default
    police rate $DOWNLOAD bps
end-policy-map

policy-map $MAP_NAME-OUT
    class class-default
    police rate $UPLOAD bps
end-policy-map

!policy-map marker_BE
!    class class-default
!	set dscp default
!end-policy-map

l2vpn
    pw-class ptp_B2B_$PW_ID
    encapsulation mpls
    control-word
    protocol ldp
    !! transport-mode vlan
    transport-mode ethernet
exit
exit
exit

l2vpn
    xconnect group ptp_B2B_$PW_ID
    p2p ptp_B2B_$PW_ID
    interface $INTERFACE_SRC.$SUBINTERFACE_SRC
    neighbor ipv4 $NEIGHBOR_DST pw-id $PW_ID
    pw-class ptp_B2B_$PW_ID
    exit
exit
exit
exit

";
}

?>
